% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_modify_event_subscription}
\alias{docdb_modify_event_subscription}
\title{Modifies an existing Amazon DocumentDB event notification subscription}
\usage{
docdb_modify_event_subscription(
  SubscriptionName,
  SnsTopicArn = NULL,
  SourceType = NULL,
  EventCategories = NULL,
  Enabled = NULL
)
}
\arguments{
\item{SubscriptionName}{[required] The name of the Amazon DocumentDB event notification subscription.}

\item{SnsTopicArn}{The Amazon Resource Name (ARN) of the SNS topic created for event
notification. The ARN is created by Amazon SNS when you create a topic
and subscribe to it.}

\item{SourceType}{The type of source that is generating the events. For example, if you
want to be notified of events generated by an instance, set this
parameter to \code{db-instance}. If this value is not specified, all events
are returned.

Valid values: \code{db-instance}, \code{db-parameter-group}, \code{db-security-group}}

\item{EventCategories}{A list of event categories for a \code{SourceType} that you want to subscribe
to.}

\item{Enabled}{A Boolean value; set to \code{true} to activate the subscription.}
}
\description{
Modifies an existing Amazon DocumentDB event notification subscription.

See \url{https://paws-r.github.io/docs/docdb/modify_event_subscription.html} for full documentation.
}
\keyword{internal}
