% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_cluster_maintenance}
\alias{redshift_modify_cluster_maintenance}
\title{Modifies the maintenance settings of a cluster}
\usage{
redshift_modify_cluster_maintenance(ClusterIdentifier, DeferMaintenance,
  DeferMaintenanceIdentifier, DeferMaintenanceStartTime,
  DeferMaintenanceEndTime, DeferMaintenanceDuration)
}
\arguments{
\item{ClusterIdentifier}{[required] A unique identifier for the cluster.}

\item{DeferMaintenance}{A boolean indicating whether to enable the deferred maintenance window.}

\item{DeferMaintenanceIdentifier}{A unique identifier for the deferred maintenance window.}

\item{DeferMaintenanceStartTime}{A timestamp indicating the start time for the deferred maintenance
window.}

\item{DeferMaintenanceEndTime}{A timestamp indicating end time for the deferred maintenance window. If
you specify an end time, you can\'t specify a duration.}

\item{DeferMaintenanceDuration}{An integer indicating the duration of the maintenance window in days. If
you specify a duration, you can\'t specify an end time. The duration
must be 45 days or less.}
}
\description{
Modifies the maintenance settings of a cluster.
}
\section{Request syntax}{
\preformatted{svc$modify_cluster_maintenance(
  ClusterIdentifier = "string",
  DeferMaintenance = TRUE|FALSE,
  DeferMaintenanceIdentifier = "string",
  DeferMaintenanceStartTime = as.POSIXct(
    "2015-01-01"
  ),
  DeferMaintenanceEndTime = as.POSIXct(
    "2015-01-01"
  ),
  DeferMaintenanceDuration = 123
)
}
}

\keyword{internal}
