% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_parameter_group}
\alias{rds_modify_db_parameter_group}
\title{Modifies the parameters of a DB parameter group}
\usage{
rds_modify_db_parameter_group(DBParameterGroupName, Parameters)
}
\arguments{
\item{DBParameterGroupName}{[required] The name of the DB parameter group.

Constraints:
\itemize{
\item If supplied, must match the name of an existing \code{DBParameterGroup}.
}}

\item{Parameters}{[required] An array of parameter names, values, and the apply method for the
parameter update. At least one parameter name, value, and apply method
must be supplied; subsequent arguments are optional. A maximum of 20
parameters can be modified in a single request.

Valid Values (for the application method): \code{immediate | pending-reboot}

You can use the immediate value with dynamic parameters only. You can
use the pending-reboot value for both dynamic and static parameters, and
changes are applied when you reboot the DB instance without failover.}
}
\description{
Modifies the parameters of a DB parameter group. To modify more than one
parameter, submit a list of the following: \code{ParameterName},
\code{ParameterValue}, and \code{ApplyMethod}. A maximum of 20 parameters can be
modified in a single request.
}
\details{
Changes to dynamic parameters are applied immediately. Changes to static
parameters require a reboot without failover to the DB instance
associated with the parameter group before the change can take effect.

After you modify a DB parameter group, you should wait at least 5
minutes before creating your first DB instance that uses that DB
parameter group as the default parameter group. This allows Amazon RDS
to fully complete the modify action before the parameter group is used
as the default for a new DB instance. This is especially important for
parameters that are critical when creating the default database for a DB
instance, such as the character set for the default database defined by
the \code{character_set_database} parameter. You can use the \emph{Parameter
Groups} option of the \href{https://console.aws.amazon.com/rds/}{Amazon RDS console} or the
\emph{DescribeDBParameters} command to verify that your DB parameter group
has been created or modified.
}
\section{Request syntax}{
\preformatted{svc$modify_db_parameter_group(
  DBParameterGroupName = "string",
  Parameters = list(
    list(
      ParameterName = "string",
      ParameterValue = "string",
      Description = "string",
      Source = "string",
      ApplyType = "string",
      DataType = "string",
      AllowedValues = "string",
      IsModifiable = TRUE|FALSE,
      MinimumEngineVersion = "string",
      ApplyMethod = "immediate"|"pending-reboot",
      SupportedEngineModes = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
