% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_remove_role_from_db_cluster}
\alias{neptune_remove_role_from_db_cluster}
\title{Disassociates an Identity and Access Management (IAM) role from a DB
cluster}
\usage{
neptune_remove_role_from_db_cluster(DBClusterIdentifier, RoleArn)
}
\arguments{
\item{DBClusterIdentifier}{[required] The name of the DB cluster to disassociate the IAM role from.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role to disassociate from the
DB cluster, for example
\code{arn:aws:iam::123456789012:role/NeptuneAccessRole}.}
}
\description{
Disassociates an Identity and Access Management (IAM) role from a DB
cluster.
}
\section{Request syntax}{
\preformatted{svc$remove_role_from_db_cluster(
  DBClusterIdentifier = "string",
  RoleArn = "string"
)
}
}

\keyword{internal}
