% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_modify_event_subscription}
\alias{neptune_modify_event_subscription}
\title{Modifies an existing event notification subscription}
\usage{
neptune_modify_event_subscription(SubscriptionName, SnsTopicArn,
  SourceType, EventCategories, Enabled)
}
\arguments{
\item{SubscriptionName}{[required] The name of the event notification subscription.}

\item{SnsTopicArn}{The Amazon Resource Name (ARN) of the SNS topic created for event
notification. The ARN is created by Amazon SNS when you create a topic
and subscribe to it.}

\item{SourceType}{The type of source that is generating the events. For example, if you
want to be notified of events generated by a DB instance, you would set
this parameter to db-instance. if this value is not specified, all
events are returned.

Valid values: db-instance | db-parameter-group | db-security-group |
db-snapshot}

\item{EventCategories}{A list of event categories for a SourceType that you want to subscribe
to. You can see a list of the categories for a given SourceType by using
the \strong{DescribeEventCategories} action.}

\item{Enabled}{A Boolean value; set to \strong{true} to activate the subscription.}
}
\value{
A list with the following syntax:\preformatted{list(
  EventSubscription = list(
    CustomerAwsId = "string",
    CustSubscriptionId = "string",
    SnsTopicArn = "string",
    Status = "string",
    SubscriptionCreationTime = "string",
    SourceType = "string",
    SourceIdsList = list(
      "string"
    ),
    EventCategoriesList = list(
      "string"
    ),
    Enabled = TRUE|FALSE,
    EventSubscriptionArn = "string"
  )
)
}
}
\description{
Modifies an existing event notification subscription. Note that you
can't modify the source identifiers using this call; to change source
identifiers for a subscription, use the
\code{\link[=neptune_add_source_identifier_to_subscription]{add_source_identifier_to_subscription}}
and
\code{\link[=neptune_remove_source_identifier_from_subscription]{remove_source_identifier_from_subscription}}
calls.

You can see a list of the event categories for a given SourceType by
using the \strong{DescribeEventCategories} action.
}
\section{Request syntax}{
\preformatted{svc$modify_event_subscription(
  SubscriptionName = "string",
  SnsTopicArn = "string",
  SourceType = "string",
  EventCategories = list(
    "string"
  ),
  Enabled = TRUE|FALSE
)
}
}

\keyword{internal}
