% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdsdataservice_operations.R
\name{rdsdataservice_commit_transaction}
\alias{rdsdataservice_commit_transaction}
\title{Ends a SQL transaction started with the BeginTransaction operation and
commits the changes}
\usage{
rdsdataservice_commit_transaction(resourceArn, secretArn, transactionId)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.}

\item{secretArn}{[required] The name or ARN of the secret that enables access to the DB cluster.}

\item{transactionId}{[required] The identifier of the transaction to end and commit.}
}
\value{
A list with the following syntax:\preformatted{list(
  transactionStatus = "string"
)
}
}
\description{
Ends a SQL transaction started with the
\code{\link[=rdsdataservice_begin_transaction]{begin_transaction}} operation and
commits the changes.
}
\section{Request syntax}{
\preformatted{svc$commit_transaction(
  resourceArn = "string",
  secretArn = "string",
  transactionId = "string"
)
}
}

\keyword{internal}
