% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_delete_global_cluster}
\alias{rds_delete_global_cluster}
\title{Deletes a global database cluster}
\usage{
rds_delete_global_cluster(GlobalClusterIdentifier)
}
\arguments{
\item{GlobalClusterIdentifier}{[required] The cluster identifier of the global database cluster being deleted.}
}
\value{
A list with the following syntax:\preformatted{list(
  GlobalCluster = list(
    GlobalClusterIdentifier = "string",
    GlobalClusterResourceId = "string",
    GlobalClusterArn = "string",
    Status = "string",
    Engine = "string",
    EngineVersion = "string",
    DatabaseName = "string",
    StorageEncrypted = TRUE|FALSE,
    DeletionProtection = TRUE|FALSE,
    GlobalClusterMembers = list(
      list(
        DBClusterArn = "string",
        Readers = list(
          "string"
        ),
        IsWriter = TRUE|FALSE,
        GlobalWriteForwardingStatus = "enabled"|"disabled"|"enabling"|"disabling"|"unknown"
      )
    )
  )
)
}
}
\description{
Deletes a global database cluster. The primary and secondary clusters
must already be detached or destroyed first.

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$delete_global_cluster(
  GlobalClusterIdentifier = "string"
)
}
}

\keyword{internal}
