% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_delete_db_cluster_endpoint}
\alias{neptune_delete_db_cluster_endpoint}
\title{Deletes a custom endpoint and removes it from an Amazon Neptune DB
cluster}
\usage{
neptune_delete_db_cluster_endpoint(DBClusterEndpointIdentifier)
}
\arguments{
\item{DBClusterEndpointIdentifier}{[required] The identifier associated with the custom endpoint. This parameter is
stored as a lowercase string.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBClusterEndpointIdentifier = "string",
  DBClusterIdentifier = "string",
  DBClusterEndpointResourceIdentifier = "string",
  Endpoint = "string",
  Status = "string",
  EndpointType = "string",
  CustomEndpointType = "string",
  StaticMembers = list(
    "string"
  ),
  ExcludedMembers = list(
    "string"
  ),
  DBClusterEndpointArn = "string"
)
}
}
\description{
Deletes a custom endpoint and removes it from an Amazon Neptune DB
cluster.
}
\section{Request syntax}{
\preformatted{svc$delete_db_cluster_endpoint(
  DBClusterEndpointIdentifier = "string"
)
}
}

\keyword{internal}
