% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_batch_write_item}
\alias{dynamodb_batch_write_item}
\title{The BatchWriteItem operation puts or deletes multiple items in one or
more tables}
\usage{
dynamodb_batch_write_item(RequestItems, ReturnConsumedCapacity,
  ReturnItemCollectionMetrics)
}
\arguments{
\item{RequestItems}{[required] A map of one or more table names and, for each table, a list of
operations to be performed (\code{DeleteRequest} or \code{PutRequest}). Each
element in the map consists of the following:
\itemize{
\item \code{DeleteRequest} - Perform a \code{DeleteItem} operation on the specified
item. The item to be deleted is identified by a \code{Key} subelement:
\itemize{
\item \code{Key} - A map of primary key attribute values that uniquely
identify the item. Each entry in this map consists of an
attribute name and an attribute value. For each primary key, you
must provide \emph{all} of the key attributes. For example, with a
simple primary key, you only need to provide a value for the
partition key. For a composite primary key, you must provide
values for \emph{both} the partition key and the sort key.
}
\item \code{PutRequest} - Perform a \code{PutItem} operation on the specified item.
The item to be put is identified by an \code{Item} subelement:
\itemize{
\item \code{Item} - A map of attributes and their values. Each entry in
this map consists of an attribute name and an attribute value.
Attribute values must not be null; string and binary type
attributes must have lengths greater than zero; and set type
attributes must not be empty. Requests that contain empty values
are rejected with a \code{ValidationException} exception.

If you specify any attributes that are part of an index key,
then the data types for those attributes must match those of the
schema in the table's attribute definition.
}
}}

\item{ReturnConsumedCapacity}{}

\item{ReturnItemCollectionMetrics}{Determines whether item collection metrics are returned. If set to
\code{SIZE}, the response includes statistics about item collections, if any,
that were modified during the operation are returned in the response. If
set to \code{NONE} (the default), no statistics are returned.}
}
\description{
The \code{BatchWriteItem} operation puts or deletes multiple items in one or
more tables. A single call to \code{BatchWriteItem} can write up to 16 MB of
data, which can comprise as many as 25 put or delete requests.
Individual items to be written can be as large as 400 KB.

\code{BatchWriteItem} cannot update items. To update items, use the
\code{UpdateItem} action.

The individual \code{PutItem} and \code{DeleteItem} operations specified in
\code{BatchWriteItem} are atomic; however \code{BatchWriteItem} as a whole is not.
If any requested operations fail because the table's provisioned
throughput is exceeded or an internal processing failure occurs, the
failed operations are returned in the \code{UnprocessedItems} response
parameter. You can investigate and optionally resend the requests.
Typically, you would call \code{BatchWriteItem} in a loop. Each iteration
would check for unprocessed items and submit a new \code{BatchWriteItem}
request with those unprocessed items until all items have been
processed.

If \emph{none} of the items can be processed due to insufficient provisioned
throughput on all of the tables in the request, then \code{BatchWriteItem}
returns a \code{ProvisionedThroughputExceededException}.

If DynamoDB returns any unprocessed items, you should retry the batch
operation on those items. However, \emph{we strongly recommend that you use
an exponential backoff algorithm}. If you retry the batch operation
immediately, the underlying read or write requests can still fail due to
throttling on the individual tables. If you delay the batch operation
using exponential backoff, the individual requests in the batch are much
more likely to succeed.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.BatchOperations}{Batch Operations and Error Handling}
in the \emph{Amazon DynamoDB Developer Guide}.

With \code{BatchWriteItem}, you can efficiently write or delete large amounts
of data, such as from Amazon EMR, or copy data from another database
into DynamoDB. In order to improve performance with these large-scale
operations, \code{BatchWriteItem} does not behave in the same way as
individual \code{PutItem} and \code{DeleteItem} calls would. For example, you
cannot specify conditions on individual put and delete requests, and
\code{BatchWriteItem} does not return deleted items in the response.

If you use a programming language that supports concurrency, you can use
threads to write items in parallel. Your application must include the
necessary logic to manage the threads. With languages that don't support
threading, you must update or delete the specified items one at a time.
In both situations, \code{BatchWriteItem} performs the specified put and
delete operations in parallel, giving you the power of the thread pool
approach without having to introduce complexity into your application.

Parallel processing reduces latency, but each specified put and delete
request consumes the same number of write capacity units whether it is
processed in parallel or not. Delete operations on nonexistent items
consume one write capacity unit.

If one or more of the following is true, DynamoDB rejects the entire
batch write operation:
\itemize{
\item One or more tables specified in the \code{BatchWriteItem} request does
not exist.
\item Primary key attributes specified on an item in the request do not
match those in the corresponding table's primary key schema.
\item You try to perform multiple operations on the same item in the same
\code{BatchWriteItem} request. For example, you cannot put and delete the
same item in the same \code{BatchWriteItem} request.
\item Your request contains at least two items with identical hash and
range keys (which essentially is two put operations).
\item There are more than 25 requests in the batch.
\item Any individual item in a batch exceeds 400 KB.
\item The total request size exceeds 16 MB.
}
}
\section{Request syntax}{
\preformatted{svc$batch_write_item(
  RequestItems = list(
    list(
      list(
        PutRequest = list(
          Item = list(
            list(
              S = "string",
              N = "string",
              B = raw,
              SS = list(
                "string"
              ),
              NS = list(
                "string"
              ),
              BS = list(
                raw
              ),
              M = list(
                list()
              ),
              L = list(
                list()
              ),
              NULL = TRUE|FALSE,
              BOOL = TRUE|FALSE
            )
          )
        ),
        DeleteRequest = list(
          Key = list(
            list(
              S = "string",
              N = "string",
              B = raw,
              SS = list(
                "string"
              ),
              NS = list(
                "string"
              ),
              BS = list(
                raw
              ),
              M = list(
                list()
              ),
              L = list(
                list()
              ),
              NULL = TRUE|FALSE,
              BOOL = TRUE|FALSE
            )
          )
        )
      )
    )
  ),
  ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
  ReturnItemCollectionMetrics = "SIZE"|"NONE"
)
}
}

\examples{
\dontrun{
# This example adds three new items to the Music table using a batch of
# three PutItem requests.
svc$batch_write_item(
  RequestItems = list(
    Music = list(
      list(
        PutRequest = list(
          Item = list(
            AlbumTitle = list(
              S = "Somewhat Famous"
            ),
            Artist = list(
              S = "No One You Know"
            ),
            SongTitle = list(
              S = "Call Me Today"
            )
          )
        )
      ),
      list(
        PutRequest = list(
          Item = list(
            AlbumTitle = list(
              S = "Songs About Life"
            ),
            Artist = list(
              S = "Acme Band"
            ),
            SongTitle = list(
              S = "Happy Day"
            )
          )
        )
      ),
      list(
        PutRequest = list(
          Item = list(
            AlbumTitle = list(
              S = "Blue Sky Blues"
            ),
            Artist = list(
              S = "No One You Know"
            ),
            SongTitle = list(
              S = "Scared of My Shadow"
            )
          )
        )
      )
    )
  )
)
}

}
\keyword{internal}
