% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpledb_operations.R
\name{simpledb_get_attributes}
\alias{simpledb_get_attributes}
\title{Returns all of the attributes associated with the specified item}
\usage{
simpledb_get_attributes(DomainName, ItemName, AttributeNames,
  ConsistentRead)
}
\arguments{
\item{DomainName}{[required] The name of the domain in which to perform the operation.}

\item{ItemName}{[required] The name of the item.}

\item{AttributeNames}{The names of the attributes.}

\item{ConsistentRead}{Determines whether or not strong consistency should be enforced when data is read from SimpleDB. If <code>true</code>, any data previously written to SimpleDB will be returned. Otherwise, results will be consistent eventually, and the client may not see data that was written immediately before your read.}
}
\description{
Returns all of the attributes associated with the specified item.
Optionally, the attributes returned can be limited to one or more
attributes by specifying an attribute name parameter.
}
\details{
If the item does not exist on the replica that was accessed for this
operation, an empty set is returned. The system does not return an error
as it cannot guarantee the item does not exist on other replicas.

If GetAttributes is called without being passed any attribute names, all
the attributes for the item are returned.
}
\section{Request syntax}{
\preformatted{svc$get_attributes(
  DomainName = "string",
  ItemName = "string",
  AttributeNames = list(
    "string"
  ),
  ConsistentRead = TRUE|FALSE
)
}
}

\keyword{internal}
