% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_list_tags_for_resource}
\alias{elasticache_list_tags_for_resource}
\title{Lists all cost allocation tags currently on the named resource}
\usage{
elasticache_list_tags_for_resource(ResourceName)
}
\arguments{
\item{ResourceName}{[required] The Amazon Resource Name (ARN) of the resource for which you want the
list of tags, for example
\code{arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster} or
\code{arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot}.

For more information about ARNs, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}.}
}
\description{
Lists all cost allocation tags currently on the named resource. A
\code{cost allocation tag} is a key-value pair where the key is
case-sensitive and the value is optional. You can use cost allocation
tags to categorize and track your AWS costs.
}
\details{
If the cluster is not in the \emph{available} state, \code{ListTagsForResource}
returns an error.

You can have a maximum of 50 cost allocation tags on an ElastiCache
resource. For more information, see \href{http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html}{Monitoring Costs with Tags}.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceName = "string"
)
}
}

\keyword{internal}
