% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_put_geofence}
\alias{locationservice_put_geofence}
\title{Stores a geofence geometry in a given geofence collection, or updates
the geometry of an existing geofence if a geofence ID is included in the
request}
\usage{
locationservice_put_geofence(
  CollectionName,
  GeofenceId,
  Geometry,
  GeofenceProperties = NULL
)
}
\arguments{
\item{CollectionName}{[required] The geofence collection to store the geofence in.}

\item{GeofenceId}{[required] An identifier for the geofence. For example, \code{ExampleGeofence-1}.}

\item{Geometry}{[required] Contains the details to specify the position of the geofence. Can be a
polygon, a circle or a polygon encoded in Geobuf format. Including
multiple selections will return a validation error.

The \href{https://docs.aws.amazon.com/location/latest/APIReference/API_GeofenceGeometry.html}{geofence polygon}
format supports a maximum of 1,000 vertices. The \href{https://docs.aws.amazon.com/location/latest/APIReference/API_GeofenceGeometry.html}{Geofence Geobuf}
format supports a maximum of 100,000 vertices.}

\item{GeofenceProperties}{Associates one of more properties with the geofence. A property is a
key-value pair stored with the geofence and added to any geofence event
triggered with that geofence.

Format: \code{"key" : "value"}}
}
\description{
Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.

See \url{https://www.paws-r-sdk.com/docs/locationservice_put_geofence/} for full documentation.
}
\keyword{internal}
