% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_list_queue_tags}
\alias{sqs_list_queue_tags}
\title{List all cost allocation tags added to the specified Amazon SQS queue}
\usage{
sqs_list_queue_tags(QueueUrl)
}
\arguments{
\item{QueueUrl}{[required] The URL of the queue.}
}
\description{
List all cost allocation tags added to the specified Amazon SQS queue.
For an overview, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html}{Tagging Your Amazon SQS Queues}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\details{
Cross-account permissions don\'t apply to this action. For more
information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name}{Grant Cross-Account Permissions to a Role and a User Name}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_queue_tags(
  QueueUrl = "string"
)
}
}

\keyword{internal}
