% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_create_platform_endpoint}
\alias{sns_create_platform_endpoint}
\title{Creates an endpoint for a device and mobile app on one of the supported
push notification services, such as FCM and APNS}
\usage{
sns_create_platform_endpoint(PlatformApplicationArn, Token,
  CustomUserData, Attributes)
}
\arguments{
\item{PlatformApplicationArn}{[required] PlatformApplicationArn returned from CreatePlatformApplication is used
to create a an endpoint.}

\item{Token}{[required] Unique identifier created by the notification service for an app on a
device. The specific name for Token will vary, depending on which
notification service is being used. For example, when using APNS as the
notification service, you need the device token. Alternatively, when
using FCM or ADM, the device token equivalent is called the registration
ID.}

\item{CustomUserData}{Arbitrary user data to associate with the endpoint. Amazon SNS does not
use this data. The data must be in UTF-8 format and less than 2KB.}

\item{Attributes}{For a list of attributes, see
\href{https://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html}{SetEndpointAttributes}.}
}
\description{
Creates an endpoint for a device and mobile app on one of the supported
push notification services, such as FCM and APNS.
\code{CreatePlatformEndpoint} requires the PlatformApplicationArn that is
returned from \code{CreatePlatformApplication}. The EndpointArn that is
returned when using \code{CreatePlatformEndpoint} can then be used by the
\code{Publish} action to send a message to a mobile app or by the \code{Subscribe}
action for subscription to a topic. The \code{CreatePlatformEndpoint} action
is idempotent, so if the requester already owns an endpoint with the
same device token and attributes, that endpoint\'s ARN is returned
without creating a new endpoint. For more information, see \href{https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html}{Using Amazon SNS Mobile Push Notifications}.
}
\details{
When using \code{CreatePlatformEndpoint} with Baidu, two attributes must be
provided: ChannelId and UserId. The token field must also contain the
ChannelId. For more information, see \href{https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html}{Creating an Amazon SNS Endpoint for Baidu}.
}
\section{Request syntax}{
\preformatted{svc$create_platform_endpoint(
  PlatformApplicationArn = "string",
  Token = "string",
  CustomUserData = "string",
  Attributes = list(
    "string"
  )
)
}
}

\keyword{internal}
