% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mq_operations.R
\name{mq_create_broker}
\alias{mq_create_broker}
\title{Creates a broker}
\usage{
mq_create_broker(AutoMinorVersionUpgrade, BrokerName, Configuration,
  CreatorRequestId, DeploymentMode, EncryptionOptions, EngineType,
  EngineVersion, HostInstanceType, Logs, MaintenanceWindowStartTime,
  PubliclyAccessible, SecurityGroups, StorageType, SubnetIds, Tags, Users)
}
\arguments{
\item{AutoMinorVersionUpgrade}{Required. Enables automatic upgrades to new minor versions for brokers, as Apache releases the versions. The automatic upgrades occur during the maintenance window of the broker or after a manual broker reboot.}

\item{BrokerName}{Required. The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard characters, or special characters.}

\item{Configuration}{A list of information about the configuration.}

\item{CreatorRequestId}{The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.}

\item{DeploymentMode}{Required. The deployment mode of the broker.}

\item{EncryptionOptions}{Encryption options for the broker.}

\item{EngineType}{Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.}

\item{EngineVersion}{Required. The version of the broker engine. For a list of supported engine versions, see https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html}

\item{HostInstanceType}{Required. The broker's instance type.}

\item{Logs}{Enables Amazon CloudWatch logging for brokers.}

\item{MaintenanceWindowStartTime}{The parameters that determine the WeeklyStartTime.}

\item{PubliclyAccessible}{Required. Enables connections from applications outside of the VPC that hosts the broker's subnets.}

\item{SecurityGroups}{The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.}

\item{StorageType}{The broker's storage type.}

\item{SubnetIds}{The list of groups (2 maximum) that define which subnets and IP ranges the broker can use from different Availability Zones. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ deployment requires two subnets.}

\item{Tags}{Create tags when creating the broker.}

\item{Users}{Required. The list of ActiveMQ users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.}
}
\description{
Creates a broker. Note: This API is asynchronous.
}
\section{Request syntax}{
\preformatted{svc$create_broker(
  AutoMinorVersionUpgrade = TRUE|FALSE,
  BrokerName = "string",
  Configuration = list(
    Id = "string",
    Revision = 123
  ),
  CreatorRequestId = "string",
  DeploymentMode = "SINGLE_INSTANCE"|"ACTIVE_STANDBY_MULTI_AZ",
  EncryptionOptions = list(
    KmsKeyId = "string",
    UseAwsOwnedKey = TRUE|FALSE
  ),
  EngineType = "ACTIVEMQ",
  EngineVersion = "string",
  HostInstanceType = "string",
  Logs = list(
    Audit = TRUE|FALSE,
    General = TRUE|FALSE
  ),
  MaintenanceWindowStartTime = list(
    DayOfWeek = "MONDAY"|"TUESDAY"|"WEDNESDAY"|"THURSDAY"|"FRIDAY"|"SATURDAY"|"SUNDAY",
    TimeOfDay = "string",
    TimeZone = "string"
  ),
  PubliclyAccessible = TRUE|FALSE,
  SecurityGroups = list(
    "string"
  ),
  StorageType = "EBS"|"EFS",
  SubnetIds = list(
    "string"
  ),
  Tags = list(
    "string"
  ),
  Users = list(
    list(
      ConsoleAccess = TRUE|FALSE,
      Groups = list(
        "string"
      ),
      Password = "string",
      Username = "string"
    )
  )
)
}
}

\keyword{internal}
