% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_create_state_machine}
\alias{sfn_create_state_machine}
\title{Creates a state machine}
\usage{
sfn_create_state_machine(name, definition, roleArn, tags)
}
\arguments{
\item{name}{[required] The name of the state machine.

A name must \emph{not} contain:
\itemize{
\item whitespace
\item brackets \code{&lt; &gt; \{ \} \\[ \\]}
\item wildcard characters \code{? *}
\item special characters \code{\" # \\\% \\ ^ | ~ \` $ &amp; , ; : /}
\item control characters (\code{U+0000-001F}, \code{U+007F-009F})
}}

\item{definition}{[required] The Amazon States Language definition of the state machine. See \href{https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html}{Amazon States Language}.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the IAM role to use for this state
machine.}

\item{tags}{Tags to be added when creating a state machine.}
}
\description{
Creates a state machine. A state machine consists of a collection of
states that can do work (\code{Task} states), determine to which states to
transition next (\code{Choice} states), stop an execution with an error
(\code{Fail} states), and so on. State machines are specified using a
JSON-based, structured language.
}
\details{
This operation is eventually consistent. The results are best effort and
may not reflect very recent updates and changes.
}
\section{Request syntax}{
\preformatted{svc$create_state_machine(
  name = "string",
  definition = "string",
  roleArn = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
