% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_create_state_machine}
\alias{sfn_create_state_machine}
\title{Creates a state machine}
\usage{
sfn_create_state_machine(name, definition, roleArn, type,
  loggingConfiguration, tags, tracingConfiguration)
}
\arguments{
\item{name}{[required] The name of the state machine.

A name must \emph{not} contain:
\itemize{
\item white space
\item brackets \verb{< > \{ \} [ ]}
\item wildcard characters \verb{? *}
\item special characters \verb{\\" # \% \\ ^ | ~ \\` $ & , ; : /}
\item control characters (\verb{U+0000-001F}, \verb{U+007F-009F})
}

To enable logging with CloudWatch Logs, the name should only contain
0-9, A-Z, a-z, - and _.

[ ]: R:\%20}

\item{definition}{[required] The Amazon States Language definition of the state machine. See \href{https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html}{Amazon States Language}.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the IAM role to use for this state
machine.}

\item{type}{Determines whether a Standard or Express state machine is created. The
default is \code{STANDARD}. You cannot update the \code{type} of a state machine
once it has been created.}

\item{loggingConfiguration}{Defines what execution history events are logged and where they are
logged.

By default, the \code{level} is set to \code{OFF}. For more information see \href{https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html}{Log Levels}
in the AWS Step Functions User Guide.}

\item{tags}{Tags to be added when creating a state machine.

An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html}{Using Cost Allocation Tags}
in the \emph{AWS Billing and Cost Management User Guide}, and \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html}{Controlling Access Using IAM Tags}.

Tags may only contain Unicode letters, digits, white space, or these
symbols: \verb{_ . : / = + - @}.}

\item{tracingConfiguration}{Selects whether AWS X-Ray tracing is enabled.}
}
\value{
A list with the following syntax:\preformatted{list(
  stateMachineArn = "string",
  creationDate = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Creates a state machine. A state machine consists of a collection of
states that can do work (\code{Task} states), determine to which states to
transition next (\code{Choice} states), stop an execution with an error
(\code{Fail} states), and so on. State machines are specified using a
JSON-based, structured language. For more information, see \href{https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html}{Amazon States Language}
in the AWS Step Functions User Guide.

This operation is eventually consistent. The results are best effort and
may not reflect very recent updates and changes.

\code{\link[=sfn_create_state_machine]{create_state_machine}} is an idempotent API.
Subsequent requests won’t create a duplicate resource if it was already
created. \code{\link[=sfn_create_state_machine]{create_state_machine}}'s
idempotency check is based on the state machine \code{name}, \code{definition},
\code{type}, \code{LoggingConfiguration} and \code{TracingConfiguration}. If a
following request has a different \code{roleArn} or \code{tags}, Step Functions
will ignore these differences and treat it as an idempotent request of
the previous. In this case, \code{roleArn} and \code{tags} will not be updated,
even if they are different.
}
\section{Request syntax}{
\preformatted{svc$create_state_machine(
  name = "string",
  definition = "string",
  roleArn = "string",
  type = "STANDARD"|"EXPRESS",
  loggingConfiguration = list(
    level = "ALL"|"ERROR"|"FATAL"|"OFF",
    includeExecutionData = TRUE|FALSE,
    destinations = list(
      list(
        cloudWatchLogsLogGroup = list(
          logGroupArn = "string"
        )
      )
    )
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  tracingConfiguration = list(
    enabled = TRUE|FALSE
  )
)
}
}

\keyword{internal}
