% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_list_event_buses}
\alias{eventbridge_list_event_buses}
\title{Lists all the event buses in your account, including the default event
bus, custom event buses, and partner event buses}
\usage{
eventbridge_list_event_buses(NamePrefix, NextToken, Limit)
}
\arguments{
\item{NamePrefix}{Specifying this limits the results to only those event buses with names
that start with the specified prefix.}

\item{NextToken}{The token returned by a previous call to retrieve the next set of
results.}

\item{Limit}{Specifying this limits the number of results returned by this operation.
The operation also returns a NextToken which you can use in a subsequent
operation to retrieve the next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  EventBuses = list(
    list(
      Name = "string",
      Arn = "string",
      Policy = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists all the event buses in your account, including the default event
bus, custom event buses, and partner event buses.
}
\section{Request syntax}{
\preformatted{svc$list_event_buses(
  NamePrefix = "string",
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
