% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivsrealtime_operations.R
\name{ivsrealtime_create_storage_configuration}
\alias{ivsrealtime_create_storage_configuration}
\title{Creates a new storage configuration, used to enable recording to Amazon
S3}
\usage{
ivsrealtime_create_storage_configuration(name = NULL, s3, tags = NULL)
}
\arguments{
\item{name}{Storage configuration name. The value does not need to be unique.}

\item{s3}{[required] A complex type that contains a storage configuration for where recorded
video will be stored.}

\item{tags}{Tags attached to the resource. Array of maps, each of the form
\code{string:string (key:value)}. See \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html}{Best practices and strategies}
in \emph{Tagging AWS Resources and Tag Editor} for details, including
restrictions that apply to tags and "Tag naming limits and
requirements"; Amazon IVS has no constraints on tags beyond what is
documented there.}
}
\description{
Creates a new storage configuration, used to enable recording to Amazon S3. When a StorageConfiguration is created, IVS will modify the S3 bucketPolicy of the provided bucket. This will ensure that IVS has sufficient permissions to write content to the provided bucket.

See \url{https://www.paws-r-sdk.com/docs/ivsrealtime_create_storage_configuration/} for full documentation.
}
\keyword{internal}
