% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_subscription_targets}
\alias{datazone_list_subscription_targets}
\title{Lists subscription targets in Amazon DataZone}
\usage{
datazone_list_subscription_targets(
  domainIdentifier,
  environmentIdentifier,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  sortOrder = NULL
)
}
\arguments{
\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain where you want to list
subscription targets.}

\item{environmentIdentifier}{[required] The identifier of the environment where you want to list subscription
targets.}

\item{maxResults}{The maximum number of subscription targets to return in a single call to
\code{\link[=datazone_list_subscription_targets]{list_subscription_targets}}. When
the number of subscription targets to be listed is greater than the
value of \code{MaxResults}, the response contains a \code{NextToken} value that
you can use in a subsequent call to
\code{\link[=datazone_list_subscription_targets]{list_subscription_targets}} to
list the next set of subscription targets.}

\item{nextToken}{When the number of subscription targets is greater than the default
value for the \code{MaxResults} parameter, or if you explicitly specify a
value for \code{MaxResults} that is less than the number of subscription
targets, the response includes a pagination token named \code{NextToken}. You
can specify this \code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_subscription_targets]{list_subscription_targets}} to
list the next set of subscription targets.}

\item{sortBy}{Specifies the way in which the results of this action are to be sorted.}

\item{sortOrder}{Specifies the sort order for the results of this action.}
}
\description{
Lists subscription targets in Amazon DataZone.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_subscription_targets/} for full documentation.
}
\keyword{internal}
