% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_environments}
\alias{datazone_list_environments}
\title{Lists Amazon DataZone environments}
\usage{
datazone_list_environments(
  awsAccountId = NULL,
  awsAccountRegion = NULL,
  domainIdentifier,
  environmentBlueprintIdentifier = NULL,
  environmentProfileIdentifier = NULL,
  maxResults = NULL,
  name = NULL,
  nextToken = NULL,
  projectIdentifier,
  provider = NULL,
  status = NULL
)
}
\arguments{
\item{awsAccountId}{The identifier of the Amazon Web Services account where you want to list
environments.}

\item{awsAccountRegion}{The Amazon Web Services region where you want to list environments.}

\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain.}

\item{environmentBlueprintIdentifier}{The identifier of the Amazon DataZone blueprint.}

\item{environmentProfileIdentifier}{The identifier of the environment profile.}

\item{maxResults}{The maximum number of environments to return in a single call to
\code{\link[=datazone_list_environments]{list_environments}}. When the number of
environments to be listed is greater than the value of \code{MaxResults}, the
response contains a \code{NextToken} value that you can use in a subsequent
call to \code{\link[=datazone_list_environments]{list_environments}} to list the
next set of environments.}

\item{name}{}

\item{nextToken}{When the number of environments is greater than the default value for
the \code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of environments, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_environments]{list_environments}} to list the next set
of environments.}

\item{projectIdentifier}{[required] The identifier of the Amazon DataZone project.}

\item{provider}{The provider of the environment.}

\item{status}{The status of the environments that you want to list.}
}
\description{
Lists Amazon DataZone environments.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_environments/} for full documentation.
}
\keyword{internal}
