% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_tag_resource}
\alias{athena_tag_resource}
\title{Adds one or more tags to an Athena resource}
\usage{
athena_tag_resource(ResourceARN, Tags)
}
\arguments{
\item{ResourceARN}{[required] Specifies the ARN of the Athena resource to which tags are to be added.}

\item{Tags}{[required] A collection of one or more tags, separated by commas, to be added to an
Athena resource.}
}
\description{
Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups, data catalogs, or capacity reservations by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter the resources in your account. For best practices, see \href{https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html}{Tagging Best Practices}. Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas.

See \url{https://www.paws-r-sdk.com/docs/athena_tag_resource/} for full documentation.
}
\keyword{internal}
