% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_list_themes}
\alias{quicksight_list_themes}
\title{Lists all the themes in the current Amazon Web Services account}
\usage{
quicksight_list_themes(
  AwsAccountId,
  NextToken = NULL,
  MaxResults = NULL,
  Type = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account that contains the themes that
you're listing.}

\item{NextToken}{The token for the next set of results, or null if there are no more
results.}

\item{MaxResults}{The maximum number of results to be returned per request.}

\item{Type}{The type of themes that you want to list. Valid options include the
following:
\itemize{
\item \code{ALL (default)}- Display all existing themes.
\item \code{CUSTOM} - Display only the themes created by people using Amazon
QuickSight.
\item \code{QUICKSIGHT} - Display only the starting themes defined by Amazon
QuickSight.
}}
}
\description{
Lists all the themes in the current Amazon Web Services account.

See \url{https://paws-r.github.io/docs/quicksight/list_themes.html} for full documentation.
}
\keyword{internal}
