% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_create_query_suggestions_block_list}
\alias{kendra_create_query_suggestions_block_list}
\title{Creates a block list to exlcude certain queries from suggestions}
\usage{
kendra_create_query_suggestions_block_list(
  IndexId,
  Name,
  Description = NULL,
  SourceS3Path,
  ClientToken = NULL,
  RoleArn,
  Tags = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index you want to create a query suggestions block
list for.}

\item{Name}{[required] A user friendly name for the block list.

For example, the block list named 'offensive-words' includes all
offensive words that could appear in user queries and need to be blocked
from suggestions.}

\item{Description}{A user-friendly description for the block list.

For example, the description "List of all offensive words that can
appear in user queries and need to be blocked from suggestions."}

\item{SourceS3Path}{[required] The S3 path to your block list text file in your S3 bucket.

Each block word or phrase should be on a separate line in a text file.

For information on the current quota limits for block lists, see \href{https://docs.aws.amazon.com/kendra/latest/dg/quotas.html}{Quotas for Amazon Kendra}.}

\item{ClientToken}{A token that you provide to identify the request to create a query
suggestions block list.}

\item{RoleArn}{[required] The IAM (Identity and Access Management) role used by Amazon Kendra to
access the block list text file in your S3 bucket.

You need permissions to the role ARN (Amazon Web Services Resource
Name). The role needs S3 read permissions to your file in S3 and needs
to give STS (Security Token Service) assume role permissions to Amazon
Kendra.}

\item{Tags}{A tag that you can assign to a block list that categorizes the block
list.}
}
\description{
Creates a block list to exlcude certain queries from suggestions.

See \url{https://paws-r.github.io/docs/kendra/create_query_suggestions_block_list.html} for full documentation.
}
\keyword{internal}
