% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_list_notebook_executions}
\alias{emr_list_notebook_executions}
\title{Provides summaries of all notebook executions}
\usage{
emr_list_notebook_executions(
  EditorId = NULL,
  Status = NULL,
  From = NULL,
  To = NULL,
  Marker = NULL
)
}
\arguments{
\item{EditorId}{The unique ID of the editor associated with the notebook execution.}

\item{Status}{The status filter for listing notebook executions.
\itemize{
\item \code{START_PENDING} indicates that the cluster has received the
execution request but execution has not begun.
\item \code{STARTING} indicates that the execution is starting on the cluster.
\item \code{RUNNING} indicates that the execution is being processed by the
cluster.
\item \code{FINISHING} indicates that execution processing is in the final
stages.
\item \code{FINISHED} indicates that the execution has completed without error.
\item \code{FAILING} indicates that the execution is failing and will not
finish successfully.
\item \code{FAILED} indicates that the execution failed.
\item \code{STOP_PENDING} indicates that the cluster has received a
\code{\link[=emr_stop_notebook_execution]{stop_notebook_execution}} request and
the stop is pending.
\item \code{STOPPING} indicates that the cluster is in the process of stopping
the execution as a result of a
\code{\link[=emr_stop_notebook_execution]{stop_notebook_execution}} request.
\item \code{STOPPED} indicates that the execution stopped because of a
\code{\link[=emr_stop_notebook_execution]{stop_notebook_execution}} request.
}}

\item{From}{The beginning of time range filter for listing notebook executions. The
default is the timestamp of 30 days ago.}

\item{To}{The end of time range filter for listing notebook executions. The
default is the current timestamp.}

\item{Marker}{The pagination token, returned by a previous
\code{\link[=emr_list_notebook_executions]{list_notebook_executions}} call, that
indicates the start of the list for this
\code{\link[=emr_list_notebook_executions]{list_notebook_executions}} call.}
}
\description{
Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status, time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a longer notebook execution list across multiple \code{ListNotebookExecution} calls.

See \url{https://paws-r.github.io/docs/emr/list_notebook_executions.html} for full documentation.
}
\keyword{internal}
