% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_register_user}
\alias{quicksight_register_user}
\title{Creates an Amazon QuickSight user, whose identity is associated with the
AWS Identity and Access Management (IAM) identity or role specified in
the request}
\usage{
quicksight_register_user(IdentityType, Email, UserRole, IamArn,
  SessionName, AwsAccountId, Namespace, UserName)
}
\arguments{
\item{IdentityType}{[required] Amazon QuickSight supports several ways of managing the identity of
users. This parameter accepts two values:
\itemize{
\item \code{IAM}: A user whose identity maps to an existing IAM user or role.
\item \code{QUICKSIGHT}: A user whose identity is owned and managed internally
by Amazon QuickSight.
}}

\item{Email}{[required] The email address of the user that you want to register.}

\item{UserRole}{[required] The Amazon QuickSight role for the user. The user role can be one of the
following:
\itemize{
\item \code{READER}: A user who has read-only access to dashboards.
\item \code{AUTHOR}: A user who can create data sources, datasets, analyses,
and dashboards.
\item \code{ADMIN}: A user who is an author, who can also manage Amazon
QuickSight settings.
\item \code{RESTRICTED_READER}: This role isn\'t currently available for use.
\item \code{RESTRICTED_AUTHOR}: This role isn\'t currently available for use.
}}

\item{IamArn}{The ARN of the IAM user or role that you are registering with Amazon
QuickSight.}

\item{SessionName}{You need to use this parameter only when you register one or more users
using an assumed IAM role. You don\'t need to provide the session name
for other scenarios, for example when you are registering an IAM user or
an Amazon QuickSight user. You can register multiple users using the
same IAM role if each user has a different session name. For more
information on assuming IAM roles, see
\href{https://awscli.amazonaws.com/v2/documentation/api/latest/reference/sts/assume-role.html}{\code{assume-role}}
in the \emph{AWS CLI Reference.}}

\item{AwsAccountId}{[required] The ID for the AWS account that the user is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}

\item{UserName}{The Amazon QuickSight user name that you want to create for the user you
are registering.}
}
\description{
Creates an Amazon QuickSight user, whose identity is associated with the
AWS Identity and Access Management (IAM) identity or role specified in
the request.
}
\section{Request syntax}{
\preformatted{svc$register_user(
  IdentityType = "IAM"|"QUICKSIGHT",
  Email = "string",
  UserRole = "ADMIN"|"AUTHOR"|"READER"|"RESTRICTED_AUTHOR"|"RESTRICTED_READER",
  IamArn = "string",
  SessionName = "string",
  AwsAccountId = "string",
  Namespace = "string",
  UserName = "string"
)
}
}

\keyword{internal}
