% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_ml_transforms}
\alias{glue_get_ml_transforms}
\title{Gets a sortable, filterable list of existing AWS Glue machine learning
transforms}
\usage{
glue_get_ml_transforms(NextToken, MaxResults, Filter, Sort)
}
\arguments{
\item{NextToken}{A paginated token to offset the results.}

\item{MaxResults}{The maximum number of results to return.}

\item{Filter}{The filter transformation criteria.}

\item{Sort}{The sorting criteria.}
}
\description{
Gets a sortable, filterable list of existing AWS Glue machine learning
transforms. Machine learning transforms are a special type of transform
that use machine learning to learn the details of the transformation to
be performed by learning from examples provided by humans. These
transformations are then saved by AWS Glue, and you can retrieve their
metadata by calling \code{GetMLTransforms}.
}
\section{Request syntax}{
\preformatted{svc$get_ml_transforms(
  NextToken = "string",
  MaxResults = 123,
  Filter = list(
    Name = "string",
    TransformType = "FIND_MATCHES",
    Status = "NOT_READY"|"READY"|"DELETING",
    GlueVersion = "string",
    CreatedBefore = as.POSIXct(
      "2015-01-01"
    ),
    CreatedAfter = as.POSIXct(
      "2015-01-01"
    ),
    LastModifiedBefore = as.POSIXct(
      "2015-01-01"
    ),
    LastModifiedAfter = as.POSIXct(
      "2015-01-01"
    ),
    Schema = list(
      list(
        Name = "string",
        DataType = "string"
      )
    )
  ),
  Sort = list(
    Column = "NAME"|"TRANSFORM_TYPE"|"STATUS"|"CREATED"|"LAST_MODIFIED",
    SortDirection = "DESCENDING"|"ASCENDING"
  )
)
}
}

\keyword{internal}
