% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_start_delivery_stream_encryption}
\alias{firehose_start_delivery_stream_encryption}
\title{Enables server-side encryption (SSE) for the delivery stream}
\usage{
firehose_start_delivery_stream_encryption(DeliveryStreamName)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream for which you want to enable server-side
encryption (SSE).}
}
\description{
Enables server-side encryption (SSE) for the delivery stream.
}
\details{
This operation is asynchronous. It returns immediately. When you invoke
it, Kinesis Data Firehose first sets the status of the stream to
\code{ENABLING}, and then to \code{ENABLED}. You can continue to read and write
data to your stream while its status is \code{ENABLING}, but the data is not
encrypted. It can take up to 5 seconds after the encryption status
changes to \code{ENABLED} before all records written to the delivery stream
are encrypted. To find out whether a record or a batch of records was
encrypted, check the response elements PutRecordOutput\$Encrypted and
PutRecordBatchOutput\$Encrypted, respectively.

To check the encryption state of a delivery stream, use
DescribeDeliveryStream.

You can only enable SSE for a delivery stream that uses \code{DirectPut} as
its source.

The \code{StartDeliveryStreamEncryption} and \code{StopDeliveryStreamEncryption}
operations have a combined limit of 25 calls per delivery stream per 24
hours. For example, you reach the limit if you call
\code{StartDeliveryStreamEncryption} 13 times and
\code{StopDeliveryStreamEncryption} 12 times for the same delivery stream in
a 24-hour period.
}
\section{Request syntax}{
\preformatted{svc$start_delivery_stream_encryption(
  DeliveryStreamName = "string"
)
}
}

\keyword{internal}
