% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_list_ingestions}
\alias{quicksight_list_ingestions}
\title{Lists the history of SPICE ingestions for a dataset}
\usage{
quicksight_list_ingestions(DataSetId, NextToken, AwsAccountId,
  MaxResults)
}
\arguments{
\item{DataSetId}{[required] The ID of the dataset used in the ingestion.}

\item{NextToken}{The token for the next set of results, or null if there are no more
results.}

\item{AwsAccountId}{[required] The AWS account ID.}

\item{MaxResults}{The maximum number of results to be returned per request.}
}
\value{
A list with the following syntax:\preformatted{list(
  Ingestions = list(
    list(
      Arn = "string",
      IngestionId = "string",
      IngestionStatus = "INITIALIZED"|"QUEUED"|"RUNNING"|"FAILED"|"COMPLETED"|"CANCELLED",
      ErrorInfo = list(
        Type = "FAILURE_TO_ASSUME_ROLE"|"INGESTION_SUPERSEDED"|"INGESTION_CANCELED"|"DATA_SET_DELETED"|"DATA_SET_NOT_SPICE"|"S3_UPLOADED_FILE_DELETED"|"S3_MANIFEST_ERROR"|"DATA_TOLERANCE_EXCEPTION"|"SPICE_TABLE_NOT_FOUND"|"DATA_SET_SIZE_LIMIT_EXCEEDED"|"ROW_SIZE_LIMIT_EXCEEDED"|"ACCOUNT_CAPACITY_LIMIT_EXCEEDED"|"CUSTOMER_ERROR"|"DATA_SOURCE_NOT_FOUND"|"IAM_ROLE_NOT_AVAILABLE"|"CONNECTION_FAILURE"|"SQL_TABLE_NOT_FOUND"|"PERMISSION_DENIED"|"SSL_CERTIFICATE_VALIDATION_FAILURE"|"OAUTH_TOKEN_FAILURE"|"SOURCE_API_LIMIT_EXCEEDED_FAILURE"|"PASSWORD_AUTHENTICATION_FAILURE"|"SQL_SCHEMA_MISMATCH_ERROR"|"INVALID_DATE_FORMAT"|"INVALID_DATAPREP_SYNTAX"|"SOURCE_RESOURCE_LIMIT_EXCEEDED"|"SQL_INVALID_PARAMETER_VALUE"|"QUERY_TIMEOUT"|"SQL_NUMERIC_OVERFLOW"|"UNRESOLVABLE_HOST"|"UNROUTABLE_HOST"|"SQL_EXCEPTION"|"S3_FILE_INACCESSIBLE"|"IOT_FILE_NOT_FOUND"|"IOT_DATA_SET_FILE_EMPTY"|"INVALID_DATA_SOURCE_CONFIG"|"DATA_SOURCE_AUTH_FAILED"|"DATA_SOURCE_CONNECTION_FAILED"|"FAILURE_TO_PROCESS_JSON_FILE"|"INTERNAL_SERVICE_ERROR",
        Message = "string"
      ),
      RowInfo = list(
        RowsIngested = 123,
        RowsDropped = 123
      ),
      QueueInfo = list(
        WaitingOnIngestion = "string",
        QueuedIngestion = "string"
      ),
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      IngestionTimeInSeconds = 123,
      IngestionSizeInBytes = 123,
      RequestSource = "MANUAL"|"SCHEDULED",
      RequestType = "INITIAL_INGESTION"|"EDIT"|"INCREMENTAL_REFRESH"|"FULL_REFRESH"
    )
  ),
  NextToken = "string",
  RequestId = "string",
  Status = 123
)
}
}
\description{
Lists the history of SPICE ingestions for a dataset.
}
\section{Request syntax}{
\preformatted{svc$list_ingestions(
  DataSetId = "string",
  NextToken = "string",
  AwsAccountId = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
