% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_describe_analysis}
\alias{quicksight_describe_analysis}
\title{Provides a summary of the metadata for an analysis}
\usage{
quicksight_describe_analysis(AwsAccountId, AnalysisId)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account that contains the analysis. You must be using
the AWS account that the analysis is in.}

\item{AnalysisId}{[required] The ID of the analysis that you're describing. The ID is part of the URL
of the analysis.}
}
\value{
A list with the following syntax:\preformatted{list(
  Analysis = list(
    AnalysisId = "string",
    Arn = "string",
    Name = "string",
    Status = "CREATION_IN_PROGRESS"|"CREATION_SUCCESSFUL"|"CREATION_FAILED"|"UPDATE_IN_PROGRESS"|"UPDATE_SUCCESSFUL"|"UPDATE_FAILED"|"DELETED",
    Errors = list(
      list(
        Type = "ACCESS_DENIED"|"SOURCE_NOT_FOUND"|"DATA_SET_NOT_FOUND"|"INTERNAL_FAILURE"|"PARAMETER_VALUE_INCOMPATIBLE"|"PARAMETER_TYPE_INVALID"|"PARAMETER_NOT_FOUND"|"COLUMN_TYPE_MISMATCH"|"COLUMN_GEOGRAPHIC_ROLE_MISMATCH"|"COLUMN_REPLACEMENT_MISSING",
        Message = "string"
      )
    ),
    DataSetArns = list(
      "string"
    ),
    ThemeArn = "string",
    CreatedTime = as.POSIXct(
      "2015-01-01"
    ),
    LastUpdatedTime = as.POSIXct(
      "2015-01-01"
    ),
    Sheets = list(
      list(
        SheetId = "string",
        Name = "string"
      )
    )
  ),
  Status = 123,
  RequestId = "string"
)
}
}
\description{
Provides a summary of the metadata for an analysis.
}
\section{Request syntax}{
\preformatted{svc$describe_analysis(
  AwsAccountId = "string",
  AnalysisId = "string"
)
}
}

\keyword{internal}
