% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_partition_indexes}
\alias{glue_get_partition_indexes}
\title{Retrieves the partition indexes associated with a table}
\usage{
glue_get_partition_indexes(CatalogId, DatabaseName, TableName,
  NextToken)
}
\arguments{
\item{CatalogId}{The catalog ID where the table resides.}

\item{DatabaseName}{[required] Specifies the name of a database from which you want to retrieve
partition indexes.}

\item{TableName}{[required] Specifies the name of a table for which you want to retrieve the
partition indexes.}

\item{NextToken}{A continuation token, included if this is a continuation call.}
}
\value{
A list with the following syntax:\preformatted{list(
  PartitionIndexDescriptorList = list(
    list(
      IndexName = "string",
      Keys = list(
        list(
          Name = "string",
          Type = "string"
        )
      ),
      IndexStatus = "CREATING"|"ACTIVE"|"DELETING"|"FAILED",
      BackfillErrors = list(
        list(
          Code = "ENCRYPTED_PARTITION_ERROR"|"INTERNAL_ERROR"|"INVALID_PARTITION_TYPE_DATA_ERROR"|"MISSING_PARTITION_VALUE_ERROR"|"UNSUPPORTED_PARTITION_CHARACTER_ERROR",
          Partitions = list(
            list(
              Values = list(
                "string"
              )
            )
          )
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves the partition indexes associated with a table.
}
\section{Request syntax}{
\preformatted{svc$get_partition_indexes(
  CatalogId = "string",
  DatabaseName = "string",
  TableName = "string",
  NextToken = "string"
)
}
}

\keyword{internal}
