% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_deactivate_pipeline}
\alias{datapipeline_deactivate_pipeline}
\title{Deactivates the specified running pipeline}
\usage{
datapipeline_deactivate_pipeline(pipelineId, cancelActive)
}
\arguments{
\item{pipelineId}{[required] The ID of the pipeline.}

\item{cancelActive}{Indicates whether to cancel any running objects. The default is true,
which sets the state of any running objects to \code{CANCELED}. If this value
is false, the pipeline is deactivated after all running objects finish.}
}
\value{
An empty list.
}
\description{
Deactivates the specified running pipeline. The pipeline is set to the
\code{DEACTIVATING} state until the deactivation process completes.

To resume a deactivated pipeline, use
\code{\link[=datapipeline_activate_pipeline]{activate_pipeline}}. By default, the
pipeline resumes from the last completed execution. Optionally, you can
specify the date and time to resume the pipeline.
}
\section{Request syntax}{
\preformatted{svc$deactivate_pipeline(
  pipelineId = "string",
  cancelActive = TRUE|FALSE
)
}
}

\keyword{internal}
