% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_activate_pipeline}
\alias{datapipeline_activate_pipeline}
\title{Validates the specified pipeline and starts processing pipeline tasks}
\usage{
datapipeline_activate_pipeline(pipelineId, parameterValues,
  startTimestamp)
}
\arguments{
\item{pipelineId}{[required] The ID of the pipeline.}

\item{parameterValues}{A list of parameter values to pass to the pipeline at activation.}

\item{startTimestamp}{The date and time to resume the pipeline. By default, the pipeline
resumes from the last completed execution.}
}
\description{
Validates the specified pipeline and starts processing pipeline tasks.
If the pipeline does not pass validation, activation fails.

If you need to pause the pipeline to investigate an issue with a
component, such as a data source or script, call DeactivatePipeline.

To activate a finished pipeline, modify the end date for the pipeline
and then activate it.
}
\section{Request syntax}{
\preformatted{svc$activate_pipeline(
  pipelineId = "string",
  parameterValues = list(
    list(
      id = "string",
      stringValue = "string"
    )
  ),
  startTimestamp = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
