% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_put_data_catalog_encryption_settings}
\alias{glue_put_data_catalog_encryption_settings}
\title{Sets the security configuration for a specified catalog}
\usage{
glue_put_data_catalog_encryption_settings(CatalogId,
  DataCatalogEncryptionSettings)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog for which to set the security configuration.
If none is provided, the AWS account ID is used by default.}

\item{DataCatalogEncryptionSettings}{[required] The security configuration to set.}
}
\description{
Sets the security configuration for a specified catalog. After the
configuration has been set, the specified encryption is applied to every
catalog write thereafter.
}
\section{Request syntax}{
\preformatted{svc$put_data_catalog_encryption_settings(
  CatalogId = "string",
  DataCatalogEncryptionSettings = list(
    EncryptionAtRest = list(
      CatalogEncryptionMode = "DISABLED"|"SSE-KMS",
      SseAwsKmsKeyId = "string"
    ),
    ConnectionPasswordEncryption = list(
      ReturnConnectionPasswordEncrypted = TRUE|FALSE,
      AwsKmsKeyId = "string"
    )
  )
)
}
}

\keyword{internal}
