% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colspace.r
\name{colspace}
\alias{colspace}
\title{Model spectra in a colorspace}
\usage{
colspace(vismodeldata, space = c("auto", "di", "tri", "tcs", "hexagon", "coc",
  "categorical", "ciexyz", "cielab"))
}
\arguments{
\item{vismodeldata}{(required) quantum catch color data. Can be either the result
from \code{\link{vismodel}} or independently calculated data (in the form of a data frame
with columns representing quantum catches).}

\item{space}{Which colorspace/model to use. Options are:
\itemize{
   \item \code{auto}: if data is a result from \code{vismodel}, 
   applies \code{di}, \code{tri} or \code{tcs} if input visual model had two, three or four
   cones, respectively.
   \item \code{di}: dichromatic colourspace. See \code{\link{dispace}} for details.
   \item \code{tri}: trichromatic colourspace (i.e. Maxwell triangle). See \code{\link{trispace}} for details.
   \item \code{tcs}: tetrahedral colourspace. See \code{\link{tcspace}} for details.
   \item \code{hexagon}: the trichromatic colour-hexagon of Chittka (1992). See \code{\link{hexagon}} for details.
   \item \code{coc}: the trichromatic colour-opponent-coding model of Backhaus (1991). See \code{\link{coc}} for details.
   \item \code{categorical}: the tetrachromatic categorical fly-model of Troje (1993). See \code{\link{categorical}} for details.
   \item \code{ciexyz}: CIEXYZ space. See \code{\link{cie}} for details.
   \item \code{cielab}: CIELAB space. See \code{\link{cie}} for details.
}}
}
\description{
Models reflectance spectra in a colorspace
}
\examples{
\dontrun{
data(flowers)

# Dichromat
vis.flowers <- vismodel(flowers, visual = 'canis')
di.flowers <- colspace(vis.flowers, space = 'di')

# Colour hexagon 
vis.flowers <- vismodel(flowers, visual = 'apis', qcatch = 'Ei', relative = FALSE, 
                        vonkries = TRUE, achro = 'l', bkg = 'green')
hex.flowers <- colspace(vis.flowers, space = 'hexagon')

# Trichromat
vis.flowers <- vismodel(flowers, visual = 'apis')
tri.flowers <- colspace(vis.flowers, space = 'tri')
plot(tri.flowers)

# Tetrachromat
vis.flowers <- vismodel(flowers, visual = 'bluetit')
tcs.flowers <- colspace(vis.flowers, space = 'tcs')

# Categorical
vis.flowers <- vismodel(flowers, visual = 'musca', achro = 'md.r1')
cat.flowers <- colspace(vis.flowers, space = 'categorical')
}

}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}

Thomas White \email{thomas.white026@gmail.com}
}
\references{
Smith T, Guild J. (1932) The CIE colorimetric standards and their use.
   Transactions of the Optical Society, 33(3), 73-134.

Westland S, Ripamonti C, Cheung V. (2012). Computational colour science 
   using MATLAB. John Wiley & Sons.

Chittka L. (1992). The colour hexagon: a chromaticity diagram
   based on photoreceptor excitations as a generalized representation of 
   colour opponency. Journal of Comparative Physiology A, 170(5), 533-543.

Chittka L, Shmida A, Troje N, Menzel R. (1994). Ultraviolet as a 
   component of flower reflections, and the colour perception of Hymenoptera. 
   Vision research, 34(11), 1489-1508.

Troje N. (1993). Spectral categories in the learning behaviour
 of blowflies. Zeitschrift fur Naturforschung C, 48, 96-96.

Stoddard, M. C., & Prum, R. O. (2008). Evolution of avian plumage 
 color in a tetrahedral color space: A phylogenetic analysis of new world buntings. 
 The American Naturalist, 171(6), 755-776.

Endler, J. A., & Mielke, P. (2005). Comparing entire colour patterns 
 as birds see them. Biological Journal Of The Linnean Society, 86(4), 405-431.

Kelber A, Vorobyev M, Osorio D. (2003). Animal colour vision
   - behavioural tests and physiological concepts. Biological Reviews, 78,
   81 - 118.

Backhaus W. (1991). Color opponent coding in the visual system
 of the honeybee. Vision Research, 31, 1381-1397.
}

