% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcCV.R
\name{plotCV}
\alias{plotCV}
\title{Plot Cross-Validation Results for Pattern Causality}
\usage{
plotCV(pcCV, fr = FALSE)
}
\arguments{
\item{pcCV}{A data frame containing the cross-validation results from the \code{pcCrossValidation} function. The data frame should include columns for positive, negative, and dark causality strengths, along with the corresponding sample sizes.}

\item{fr}{A bool value for the plot frame}
}
\value{
A plot visualizing the positive, negative, and dark causality strengths across different sample sizes. The plot includes points and lines for each causality type, along with a legend for easy interpretation.
}
\description{
The \code{plotCV} function generates a plot to visualize the results of cross-validation for pattern causality. It displays the positive, negative, and dark causality strengths across different sample sizes, providing a clear graphical representation of the cross-validation outcomes.
}
\examples{
\donttest{
data(DJS)
X <- DJS$X3M
Y <- DJS$American.Express
numberset <- c(1000,2000,3000,4000)
result <- pcCrossValidation(X,Y,3,2,"euclidean",1,FALSE,numberset)
plotCV(result,FALSE)
}
}
