% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firstCausalityPoint.R
\name{firstCausalityPoint}
\alias{firstCausalityPoint}
\title{First Causality Point Function}
\usage{
firstCausalityPoint(E, tau, h, X)
}
\arguments{
\item{E}{An integer representing the embedding dimension, which influences the number of dimensions
in which the time series is reconstructed for analysis.}

\item{tau}{An integer representing the time delay, used in reconstructing the time series in the embedded space.}

\item{h}{An integer representing the prediction horizon, indicating how far ahead in the time series the predictions are aimed.}

\item{X}{A numeric vector representing the time series data.}
}
\value{
An integer indicating the first index in the time series from which causality analysis is feasible without running out of data.
If the parameters are set such that the analysis is not possible, the function will stop and provide an error message.
}
\description{
Calculates the earliest index in a time series from which causality analysis can begin,
based on the embedding dimension, time delay, prediction horizon, and the length of the series. It ensures
that there are enough data points for conducting a causality analysis without running out of data.
}
\examples{
time_series <- rnorm(1000) # Generate a random time series of 1000 points
embedding_dim <- 3 # Set embedding dimension
time_delay <- 2 # Set time delay
pred_horizon <- 1 # Set prediction horizon

# Calculate the first causality point
fc_point <- firstCausalityPoint(embedding_dim, time_delay, pred_horizon, time_series)
print(fc_point)
}
