% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_functions.R
\name{bind_viewr_objects}
\alias{bind_viewr_objects}
\title{Bind viewr objects}
\usage{
bind_viewr_objects(obj_list)
}
\arguments{
\item{obj_list}{A list of viewr objects}
}
\value{
A single viewr object (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) that combines all the
rows of the source viewr objects in \code{obj_list}. Metadata may not
necessarily be retained and therefore \code{attributes} should be used with
caution.
}
\description{
Combine a list of multiple viewr objects into a single viewr object
}
\examples{
## Since we only have one example file of each type provided
## in pathviewr, we will simply import the same example multiple
## times to simulate batch importing. Replace the contents of
## the following list with your own list of files to be imported.

## Make a list of the same example file 3x
import_list <-
  c(rep(
    system.file("extdata", "pathviewr_motive_example_data.csv",
                package = 'pathviewr'),
    3
  ))

## Batch import
motive_batch_imports <-
  import_batch(import_list,
               import_method = "motive",
               import_messaging = TRUE)

## Batch cleaning of these imported files
## via clean_viewr_batch()
motive_batch_cleaned <-
  clean_viewr_batch(
    file_announce = TRUE,
    motive_batch_imports,
    desired_percent = 50,
    max_frame_gap = "autodetect",
    span = 0.95
  )

## Alternatively, use import_and_clean_batch() to
## combine import with cleaning on a batch of files
motive_batch_import_and_clean <-
  import_and_clean_batch(
    import_list,
    import_method = "motive",
    import_messaging = TRUE,
    motive_batch_imports,
    desired_percent = 50,
    max_frame_gap = "autodetect",
    span = 0.95
  )

## Each of these lists of objects can be bound into
## one viewr object (i.e. one tibble) via
## bind_viewr_objects()
motive_bound_one <-
  bind_viewr_objects(motive_batch_cleaned)

motive_bound_two <-
  bind_viewr_objects(motive_batch_import_and_clean)

## Either route results in the same object ultimately:
identical(motive_bound_one, motive_bound_two)
}
\seealso{
Other batch functions: 
\code{\link{clean_viewr_batch}()},
\code{\link{import_and_clean_batch}()},
\code{\link{import_batch}()}
}
\author{
Vikram B. Baliga
}
\concept{batch functions}
