% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{get_header_viewr}
\alias{get_header_viewr}
\title{Extract header info from imported viewr object}
\usage{
get_header_viewr(obj_name, ...)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}
\code{pathviewr_steps}}

\item{...}{Additional arguments that may be passed to other \code{pathviewr}
functions}
}
\value{
The value of the \code{header} attribute, or NULL if no exact match
is found and no or more than one partial match is found.
}
\description{
A function to quickly return the information stored in the header of the
original data file imported via \code{pathviewr}'s \code{read_} functions.
}
\examples{
library(pathviewr)

## Import the Motive example data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                             package = 'pathviewr'))

## Now display the Header information
get_header_viewr(motive_data)
}
\author{
Vikram B. Baliga
}
\concept{metadata handling functions}
