% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{enrichment_chart}
\alias{enrichment_chart}
\title{Create Bubble Chart of Enrichment Results}
\usage{
enrichment_chart(
  result_df,
  top_terms = 10,
  plot_by_cluster = FALSE,
  num_bubbles = 4,
  even_breaks = TRUE
)
}
\arguments{
\item{result_df}{a data frame that must contain the following columns: \describe{
  \item{Term_Description}{Description of the enriched term}
  \item{Fold_Enrichment}{Fold enrichment value for the enriched term}
  \item{lowest_p}{the lowest adjusted-p value of the given term over all iterations}
  \item{Up_regulated}{the up-regulated genes in the input involved in the given term's gene set, comma-separated}
  \item{Down_regulated}{the down-regulated genes in the input involved in the given term's gene set, comma-separated}
  \item{Cluster(OPTIONAL)}{the cluster to which the enriched term is assigned}
}}

\item{top_terms}{number of top terms (according to the "lowest_p" column)
to plot (default = 10). If \code{plot_by_cluster = TRUE}, selects the top
\code{top_terms} terms per each cluster. Set \code{top_terms = NULL} to plot
for all terms.If the total number of terms is less than \code{top_terms},
all terms are plotted.}

\item{plot_by_cluster}{boolean value indicating whether or not to group the
enriched terms by cluster (works if \code{result_df} contains a
"Cluster" column).}

\item{num_bubbles}{number of sizes displayed in the legend \code{# genes}
(Default = 4)}

\item{even_breaks}{whether or not to set even breaks for the number of sizes
displayed in the legend \code{# genes}. If \code{TRUE} (default), sets
equal breaks and the number of displayed bubbles may be different than the
number set by \code{num_bubbles}. If the exact number set by
\code{num_bubbles} is required, set this argument to \code{FALSE}}
}
\value{
a \code{\link[ggplot2]{ggplot2}} object containing the bubble chart.
The x-axis corresponds to fold enrichment values while the y-axis indicates
the enriched terms. Size of the bubble indicates the number of significant
genes in the given enriched term. Color indicates the -log10(lowest-p) value.
The closer the color is to red, the more significant the enrichment is.
Optionally, if "Cluster" is a column of \code{result_df} and
\code{plot_by_cluster == TRUE}, the enriched terms are grouped by clusters.
}
\description{
This function is used to create a ggplot2 bubble chart displaying the
enrichment results.
}
\examples{
g <- enrichment_chart(RA_output)
}
