% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aab-helper.R
\name{registerPartitionVectorSignatures}
\alias{registerPartitionVectorSignatures}
\title{Make comparison measures usable with any vectors}
\usage{
registerPartitionVectorSignatures(e)
}
\arguments{
\item{e}{The environment to register the methods in 
(mostly \code{environment()} is fine)}
}
\description{
The comparison measures are defined to use the class \linkS4class{Partition} 
as parameters. If you do not want to explicitly convert an arbitrary vector 
of class labels (probably as a result from another package's algorithm) into
a \linkS4class{Partition} instance, calling this function will create methods
for all measures that allow "ANY" input which is implicitly converted to
\linkS4class{Partition}.
}
\examples{
library(partitionComparison)
randIndex(new("Partition", c(0, 0, 0, 1, 1)), new("Partition", c(0, 0, 1, 1, 1)))
# [1] 0.6
\dontrun{randIndex(c(0, 0, 0, 1, 1), c(0, 0, 1, 1, 1))}
# Error in (function (classes, fdef, mtable) :
# unable to find an inherited method for function 'randIndex' for signature '"numeric", "numeric"'
registerPartitionVectorSignatures(environment())
randIndex(c(0, 0, 0, 1, 1), c(0, 0, 1, 1, 1))
# [1] 0.6

}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
