% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{peirce}
\alias{peirce}
\alias{peirce,Partition,Partition-method}
\alias{peirce,PairCoefficients,missing-method}
\title{Peirce Index}
\usage{
peirce(p, q)

\S4method{peirce}{Partition,Partition}(p, q)

\S4method{peirce}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Peirce index
\deqn{\frac{N_{11}N_{00} - N_{10}N_{01}}{N_{21}N'_{01}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
peirce(new("Partition", c(0, 0, 0, 1, 1)), new("Partition", c(0, 0, 1, 1, 1))) == 1/6

}
\references{
\insertRef{Peirce1884}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
