% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{baulieu2}
\alias{baulieu2}
\alias{baulieu2,Partition,Partition-method}
\alias{baulieu2,PairCoefficients,missing-method}
\title{Baulieu Index 2}
\usage{
baulieu2(p, q)

\S4method{baulieu2}{Partition,Partition}(p, q)

\S4method{baulieu2}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the index 2 of Baulieu
\deqn{\frac{ N_{11}N_{00} - N_{10}N_{01} }{ N^2 }}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
baulieu2(new("Partition", c(0, 0, 0, 1, 1)), 
         new("Partition", c(0, 0, 1, 1, 1))) == 0.04

}
\references{
\insertRef{Baulieu1989}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
