% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolve.R
\name{evolve}
\alias{evolve}
\title{Move the simulation forward one or more steps}
\usage{
evolve(simulation, steps = NULL, on_generation = NULL, ...)
}
\arguments{
\item{simulation}{A simulation object}

\item{steps}{The number of generations to progress or a function getting the
simulation object and returns \code{TRUE} if the simulation should proceed and
\code{FALSE} if it should stop. If \code{NULL} the simulation will run until
\code{alpha_min} has been reached.}

\item{on_generation}{A function to be called after each generation has been
progressed. The function will get the current state of the simulation as the
first argument. If the function returns a simulation object it will replace
the current simulation from the next generation. In the case of any other
return type the return will be discarded and the function will have no effect
outside its side-effects.}

\item{...}{Additional arguments to \code{on_generation}}
}
\value{
A simulation object with updated positions and velocities
}
\description{
This is the function that move the simulation forward in time. It is possible
to either specify the number of steps that should be simulated or let the
simulation terminate as \code{alpha_min} is reached. Note that some values of
\code{alpha} and \code{alpha_target} does not allow alpha to converge to \code{alpha_min} so
letting the simulation self-terminate can result in an infinite loop. The
default settings will result in \code{alpha_min} being reached in 300 generations.
}
\details{
Each generation in the simulation progress in the following manner:
\enumerate{
\item Check whether the specified number of generations has been reached
\item Check whether \code{alpha_min} has been reached
\item If either 1. or 2. is true, terminate the simulation
\item Apply the forces on the current particle positions and velocities in the
order they have been added
\item Reduce the velocity according to the given \code{velocity_decay}
\item Update the position and velocity based on any provided constraints
\item Calculate the new particle positions based on the new velocity
\item If given, call the \code{on_generation} function.
}
}
\examples{
graph <- tidygraph::create_notable('folkman')
sim <- graph |>
  simulate() |>
  wield(link_force) |>
  wield(manybody_force)

# Take 5 steps and tell about it
sim |> evolve(5, function(sim) {
  cat('Generation: ', evolutions(sim), '\n', sep = '')
})

# Run evolution until alpha_min is reached
sim |> evolve(NULL)

}
