% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R, R/simulation.R
\name{simulate}
\alias{simulate}
\alias{is.simulation}
\alias{simulation}
\alias{record}
\alias{clear_history}
\alias{get_history}
\alias{history_length}
\alias{reheat}
\alias{particles}
\alias{position}
\alias{velocity}
\alias{evolutions}
\title{Start a simulation based on a graph}
\usage{
simulate(graph, alpha = 1, alpha_min = 0.001, alpha_decay = 1 -
  alpha_min^(1/300), alpha_target = 0, velocity_decay = 0.4,
  setup = phyllotactic_genesis(), ...)

is.simulation(x)

record(simulation, ...)

clear_history(simulation)

get_history(simulation, age = -1)

history_length(simulation)

reheat(simulation, alpha)

particles(simulation)

position(simulation)

velocity(simulation)

evolutions(simulation)
}
\arguments{
\item{graph}{A graph in a format supported by tidygraph}

\item{alpha}{The starting alpha value. See Details.}

\item{alpha_min}{The minimum alpha value after which the simulation is
terminated. See Details.}

\item{alpha_decay}{The speed at which the alpha value decreases. See Details.}

\item{alpha_target}{The alpha value that alpha drifts towards. See Details.}

\item{velocity_decay}{The dampening factor of the system. See Details.}

\item{setup}{A function that takes the particle graph and returns a start
position and velocity to each particle. \code{particles} provides a range of
\link{genesis} functions to choose from.}

\item{...}{Additional parameters for the simulation (currently ignored)}

\item{x, simulation}{A simulation object}

\item{age}{The version to retrieve. Positive numbers count from the
beginning, while negative numbers counts backwards from current version.
Defaults to \code{-1}.}
}
\value{
A simulation object
}
\description{
This function initiates a simulation based on the provided graph and
parameters. Any graph structure with a \code{\link[tidygraph:as_tbl_graph]{tidygraph::as_tbl_graph()}} method
is supported as input. This function does not start the simulation but merely
sets it up.
}
\details{
A simulation in the context of the particles package is a series of
equidistant steps where the velocity and position of each particle is
updated. A few global rules applies to this cycle irrespectively of the
forces added to the simulation. Once a simulation is initiated an \code{alpha}
value is defined (defaults to \code{1}). At each step this alpha value is
decreased according to its distance to the \code{alpha_target} (defaults to \code{0})
and \code{alpha_decay} (defaults to ~\code{0.023}). Once the alpha value gets below
\code{alpha_min} (defaults to \code{0.001}) the simulation seizes to take additional
steps. The default values is adapted from the d3-force implementation and
corresponds to 300 steps. Conceptually the \code{alpha} progression can be seen
as a cooling off of the system as the value decreases quickly in the
beginning and then slowly reach the target value. If it is not intended to
have a system that cools off, simply set the \code{alpha_target} value to the same
as \code{alpha}. At each step, after the new particle velocities has been
calculated but before they have been applied to the positions, a dampening
factor (\code{velocity_decay}) is applied in order to simulate the gradual loss
of momentum. If this is not intended for the simulation, simply set the value
to \code{0}.
}
\section{Functions}{
\itemize{
\item \code{record}: Save the current state in the simulation's history

\item \code{clear_history}: Clear the current history from the simulation

\item \code{get_history}: Retrieve a simulation from the history

\item \code{history_length}: Get the number of versions stored in the history of the simulation

\item \code{reheat}: set the cooling of the simulation to a new value

\item \code{particles}: Extract the particle graph from a simulation

\item \code{position}: Extract the position coordinates from a simulation

\item \code{velocity}: Extract the velocity verlets from a simulation

\item \code{evolutions}: Get the number of generations the simulation has undergone
}}

\examples{
graph <- tidygraph::create_notable('folkman')
graph \%>\%
  simulate()

}
