% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_ids.R
\encoding{UTF-8}
\name{parse_ids}
\alias{parse_ids}
\title{Parse IDs from a string of delimited list of values.}
\usage{
parse_ids(
  str,
  num = NULL,
  sep = ":",
  id_length = "standard",
  perc = 0.6,
  nThread = parallel::detectCores() - 1
)
}
\arguments{
\item{str}{vector, delimited list of MRN string values.}

\item{num}{vector, delimited list of MRN numeric values.}

\item{sep}{string, divider between hospital ID and MRN. Defaults to \emph{:}.}

\item{id_length}{string, indicating whether to modify MRN length based-on required values \emph{id_length = standard}, or to keep lengths as is \emph{id_length = asis}.
If \emph{id_length = standard} then in case of \emph{MGH, BWH, MCL, EMPI and PMRN} the length of the MRNs are corrected accordingly by adding zeros, or removing numeral from the beginning.
In other cases the lengths are unchanged. Defaults to \emph{standard}.}

\item{perc}{numeric, a number between 0-1 indicating which parsed ID columns to keep. Columns present in \emph{perc x 100\%} of patients have are kept.}

\item{nThread}{integer, number of threads to use by \emph{dopar} for parallelization. If it is set to 1, then no parallel backends are created and the function is executed sequentially.}
}
\value{
data table, with columns corresponding to MRNs in the string of delimited list of values.
}
\description{
Creates columns corresponding to MRNs in the string of delimited list of values. If the string and the numeric part of the MRN
are present in the same column, then supply the column to \emph{str}. If the string portion and the numeric portion is in different columns, then
supply the string part to \emph{str} and the numeric part to \emph{num}.
}
\keyword{internal}
