% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_mic.R
\encoding{UTF-8}
\name{load_mic}
\alias{load_mic}
\title{Loads microbiology results into R.}
\usage{
load_mic(
  file,
  merge_id = "EMPI",
  sep = ":",
  id_length = "standard",
  perc = 0.6,
  na = TRUE,
  identical = TRUE,
  nThread = parallel::detectCores() - 1,
  mrn_type = FALSE,
  format_orig = FALSE
)
}
\arguments{
\item{file}{string, full file path to Mic.txt}

\item{merge_id}{string, column name to use to create \emph{ID_MERGE} column used to merge different datasets. Defaults to \emph{EPIC_PMRN},
as it is the preferred MRN in the RPDR system.}

\item{sep}{string, divider between hospital ID and MRN. Defaults to \emph{:}.}

\item{id_length}{string, indicating whether to modify MRN length based-on required values \emph{id_length = standard}, or to keep lengths as is \emph{id_length = asis}.
If \emph{id_length = standard} then in case of \emph{MGH, BWH, MCL, EMPI and PMRN} the length of the MRNs are corrected accordingly by adding zeros, or removing numeral from the beginning.
In other cases the lengths are unchanged. Defaults to \emph{standard}.}

\item{perc}{numeric, a number between 0-1 indicating which parsed ID columns to keep. Data present in \emph{perc x 100\%} of patients are kept.}

\item{na}{boolean, whether to remove columns with only NA values. Defaults to \emph{TRUE}.}

\item{identical}{boolean, whether to remove columns with identical values. Defaults to \emph{TRUE}.}

\item{nThread}{integer, number of threads to use to load data.}

\item{mrn_type}{boolean, should data in \emph{MRN_Type} and \emph{MRN} be parsed. Defaults to \emph{FALSE}, as it is not advised to parse these for all data sources as it takes considerable time.}

\item{format_orig}{boolean, should report be returned in its original formatting or should white spaces used for formatting be removed. Defaults to \emph{FALSE}.}
}
\value{
data table, with microbiology information.
\describe{
 \item{ID_MERGE}{numeric, defined IDs by \emph{merge_id}, used for merging later.}
 \item{ID_mic_EMPI}{string, Unique Partners-wide identifier assigned to the patient used to consolidate patient information
 from \emph{mic} datasource, corresponds to EMPI in RPDR. Data is formatted using pretty_mrn().}
 \item{ID_mic_PMRN}{string, Epic medical record number. This value is unique across Epic instances within the Partners network
 from \emph{mic} datasource, corresponds to EPIC_PMRN in RPDR. Data is formatted using pretty_mrn().}
 \item{ID_mic_loc}{string, if mrn_type == TRUE, then the data in \emph{MRN_Type} and \emph{MRN} are parsed into IDs corresponding to locations \emph{(loc)}. Data is formatted using pretty_mrn().}
 \item{time_mic}{POSIXct, Date when the specimen was received by the laboratory, corresponds to Microbiology_Date_Time in RPDR. Converted to POSIXct format.}
 \item{mic_org_code}{string, Internal identifier for the organism used by the source system, corresponds to Organism_Code in RPDR.}
 \item{mic_org_name}{string, Name of the organism identified or tested, corresponds to Organism_Name in RPDR.}
 \item{mic_org_text}{string, Full narrative text of the test and results, including sensitivities, corresponds to Organism_Text in RPDR.}
 \item{mic_org_comment}{string, Free-text information about the organism or result, corresponds to Organism_Comment in RPDR.}
 \item{mic_test_code}{string, Internal identifier for the test used by the source system, corresponds to Test_Code in RPDR.}
 \item{mic_test_name}{string, Name of the assay to be performed, or the results of a culture, corresponds to Test_Name in RPDR.}
 \item{mic_test_status}{string, Status of the results, i.e. preliminary or final, corresponds to Test_Status in RPDR.}
 \item{mic_test_comment}{string, Free-text information about the test and results, corresponds to Test_Comments in RPDR.}
 \item{mic_spec}{string, Type of specimen collected to perform the test, corresponds to Specimen_Type in RPDR.}
 \item{mic_spec_txt}{string, Free-text information about the specimen, its collection or its integrity, corresponds to Specimen_Comments in RPDR.}
 \item{mic_accession}{string, Internal tracking number assigned to the specimen for identification in the microbiology lab, corresponds to Microbiology_Number in RPDR.}
 }
}
\description{
Loads microbiology results into the R environment.
}
\examples{
\dontrun{
#Using defaults
d_mic <- load_mic(file = "test_Mic.txt")

#Use sequential processing
d_mic <- load_mic(file = "test_Mic.txt", nThread = 1)

#Use parallel processing and parse data in MRN_Type and MRN columns and keep all IDs
d_mic <- load_mic(file = "test_Mic.txt", nThread = 20, mrn_type = TRUE, perc = 1)
}
}
