#' @name data_rdt
#'
#' @title Example of processed rdt.txt output from RPDR using the load_rdt() function.
#'
#' @description Result of a rdt.txt output from RPDR loaded into a data table in R using \emph{load_rdt()}.
#'
#' **NOTE**: Due to potential issues with PHI and PPI, the example datasets can be downloaded from the
#' Partners Gitlab repository under *parserpdr-sample-data*.
#'
#' @docType data
#'
#' @usage data_rdt
#'
#' @format data.table
#'
#' @return data table, with radiological exam information.
#' \describe{
#'  \item{ID_MERGE}{numeric, defined IDs by \emph{merge_id}, used for merging later.}
#'  \item{ID_rdt_EMPI}{string, Unique Partners-wide identifier assigned to the patient used to consolidate patient information
#'  from \emph{rdt} datasource, corresponds to EMPI in RPDR. Data is formatted using pretty_mrn().}
#'  \item{ID_rdt_PMRN}{string, Epic medical record number. This value is unique across Epic instances within the Partners network
#'  from \emph{rdt} datasource, corresponds to EPIC_PMRN in RPDR. Data is formatted using pretty_mrn().}
#'  \item{ID_con_loc}{string, if mrn_type == TRUE, then the data in \emph{MRN_Type} and \emph{MRN} are parsed into IDs corresponding to locations. Data is formatted using pretty_mrn().}
#'  \item{time_rad_exam}{POSIXct, Date of the radiology exam, corresponds to Date in RPDR. Converted to POSIXct format.}
#'  \item{rad_mode}{string, Modality of the exam, corresponds to Mode in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{rad_group}{string, Higher-level grouping concept used to consolidate similar procedures across hospitals, corresponds to Group in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{rad_test_code}{string, Internal identifier for the procedure used by the source system, corresponds to Test_Code in RPDR.}
#'  \item{rad_test_desc}{string, Full name of the exam/study performed, corresponds to Test_Description in RPDR.}
#'  \item{rad_accession}{string, Identifier assigned to the report or procedure for Radiology tracking purposes, corresponds to Accession_Number in RPDR.}
#'  \item{rad_provider}{string, Ordering or authorizing provider for the study, corresponds to Provider in RPDR. Punctuation marks are removed.}
#'  \item{rad_clinic}{string, Specific department/location where the procedure was ordered or performed, corresponds to Clinic in RPDR. Punctuation marks are removed.}
#'  \item{rad_hosp}{string, Facility where the order was entered, corresponds to Hospital in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{rad_inpatient}{string, Classifies the type of encounter where the procedure was performed, corresponds to Inpatient_Outpatient in RPDR. Punctuation marks are removed.}
#'  }
#'
#' @encoding UTF-8

NULL
