#' @name data_lab
#'
#' @title Example of processed lab.txt output from RPDR using the load_lab() function.
#'
#' @description Result of a lab.txt output from RPDR loaded into a data table in R using \emph{load_lab()}.
#'
#' **NOTE**: Due to potential issues with PHI and PPI, the example datasets can be downloaded from the
#' Partners Gitlab repository under *parserpdr-sample-data*.
#'
#' @docType data
#'
#' @usage data_lab
#'
#' @format data.table
#'
#' @return data table, with laboratory exam information.
#' \describe{
#'  \item{ID_MERGE}{numeric, defined IDs by \emph{merge_id}, used for merging later.}
#'  \item{ID_lab_EMPI}{string, Unique Partners-wide identifier assigned to the patient used to consolidate patient information
#'  from \emph{lab} datasource, corresponds to EMPI in RPDR. Data is formatted using pretty_mrn().}
#'  \item{ID_lab_PMRN}{string, Epic medical record number. This value is unique across Epic instances within the Partners network
#'  from \emph{lab} datasource, corresponds to EPIC_PMRN in RPDR. Data is formatted using pretty_mrn().}
#'  \item{ID_lab_loc}{string, if mrn_type == TRUE, then the data in \emph{MRN_Type} and \emph{MRN} are parsed into IDs corresponding to locations. Data is formatted using pretty_mrn().}
#'  \item{time_lab_result}{POSIXct, Date when the specimen was collected, corresponds to Seq_Date_Time in RPDR. Converted to POSIXct format.}
#'  \item{lab_group}{string, Higher-level grouping concept used to consolidate similar tests across hospitals, corresponds to Group_ID in RPDR.}
#'  \item{lab_loinc}{string, Standardized LOINC code for the laboratory test, corresponds to Loinc_Code in RPDR.}
#'  \item{lab_testID}{string, Internal identifier for the test used by the source system, corresponds to Test_ID in RPDR.}
#'  \item{lab_descript}{string, Name of the lab test, corresponds to Test_Description in RPDR.}
#'  \item{lab_result}{string, Result value for the test, corresponds to Result in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{lab_result_txt}{string, Additional information included with the result. This can include instructions for interpretation or comments from the laboratory, corresponds to Result_Text in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{lab_result_abn}{string, Flag for identifying if values are outside of normal ranges or represent a significant deviation from previous values, corresponds to Abnormal_Flag in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{lab_result_unit}{string, Units associated with the result value, corresponds to Reference_Unit in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{lab_result_range}{string, Normal or therapeutic range for this value, corresponds to Reference_Range in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{lab_result_toxic}{string, Reference range of values defined as being toxic to the patient, corresponds to Toxic_Range in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{lab_spec}{string, Type of specimen collected to perform the test, corresponds to Specimen_Type in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{lab_spec_txt}{string, Free-text information about the specimen, its collection or its integrity, corresponds to Specimen_Text in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{lab_correction}{string, Free-text information about any changes made to the results, corresponds to Correction_Flag in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{lab_status}{string, Flag which indicates whether the procedure is pending or complete, corresponds to Test_Status in RPDR. Punctuation marks and white spaces are removed.}
#'  \item{lab_ord_pys}{string, Name of the ordering physician, corresponds to Ordering_Doc in RPDR. Punctuation marks are removed.}
#'  \item{lab_accession}{string, Internal tracking number assigned to the specimen for identification in the lab, corresponds to Accession in RPDR.}
#'  \item{lab_source}{string, Database source, either CDR (Clinical Data Repository) or RPDR (internal RPDR database), corresponds to Source in RPDR. Punctuation marks and white spaces are removed.}
#'  }
#'
#' @encoding UTF-8

NULL
