% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{optimizer_pointer}
\alias{optimizer_pointer}
\title{Optimize parameters of ode-systems}
\usage{
optimizer_pointer(
  integration_times,
  ode_sys,
  relative_tolerance,
  absolute_tolerances,
  lower,
  upper,
  states,
  npop,
  ngen,
  error,
  solvertype
)
}
\arguments{
\item{integration_times}{a vector containing the time course to solve the ode-system (see Details for more Information)}

\item{ode_sys}{the ode-system which will be integrated by the solver (see Details for more Information).}

\item{relative_tolerance}{a number defining the relative tolerance used by the ode-solver.}

\item{absolute_tolerances}{a vector containing the absolute tolerance(s) for each state used by the ode-solver.}

\item{lower}{a data.frame containing the lower bounds for the parameters (see Details for more Information).}

\item{upper}{a data.frame containing the upper bounds for the parameters (see Details for more Information).}

\item{states}{a data.frame containing the predetermined course of the states (see Details for more Information).}

\item{npop}{a number defining the number of particles used by the Particle Swarm Optimizer.}

\item{ngen}{a number defining the number of generations the Particle Swarm Optimizer (PSO) should run.}

\item{error}{a number defining a sufficient small error. When the PSO reach this value optimization is stopped.}

\item{solvertype}{a string defining the type of solver which should be used (bdf, ADAMS, ERK or ARK. see Details for more Information).}
}
\description{
Optimize parameters used in an ode equation in order to match values defined in the state-data.frame
}
\details{
The vector containing the time course to solve the ode-system should contain
the same entries as the time vector in the state-data.frame (it can be also be a different variable instead of time).

The ode system should be of type Rcpp::XPtr<OS>. The OS is predefined in the package.
The function should possess the following signature: int ode(double &time, std::vector<double> &parameter, std::vector<double> &states).
The first entry defines the time point when the function is called.
The second argument defines the parameter which should be optimized. There exist two different types of parameters.
Parameters can be either constant or variabel. In order to calculate a variable parameter at a specific timepoint the Catmull-Rom-Spline is used.
This vector contains the already interpolated parameters at the specific time-point, in the same order as defined in the data.frames containing the lower- and upper-boundaries.
The last argument is a vector containing the states in the same order as defined in the data.frame containing the state-information.
Thus, it is obligatory that the state-derivates in the ode-system are in the same order defined as in the data.frame.
Within the function the new states have to be saved in the states-vector. 
Please be aware that when using the approach with the Rcpp::XPtr the optimization is run in parallel. Thus, the function has to be thread-safe (among other things don't use any R Code)!

For constant parameters use only the first row (below the headers) if other parameters are variable use “NA“ in the following rows for the constant parameters.

For variable parameters at least four points are needed. If a variable parameter is not available at every time point use “NA“ instead.

The two data.frames containg lower and upper-boundaries need the parameter in the same order.

The data.frame containing the state information should hold the time course in the first column.
The header-name time is compulsory. The following columns contain the states. Take care that the states are in the same order defined in the ode system.
If a state is not available use “NA“. This is possible for every time points except the first one.
The ode solver need a start value for each state which is extracted from the first row of this file (below the headers).

The error between the solver output and the measured states is the sum of the absolute differences divided by the number of time points.
It is crucial that the states are in the same order in the text file cointaining the state-information and in the ode-system to compare the states correctly!

For solving the ode system the SUNDIALS Software is used (https://computing.llnl.gov/projects/sundials).
The last argument defines the solver-type which is used during optimization:
“bdf“,  “ADAMS“, “ERK“ or “ARK“. bdf = Backward Differentiation Formulas, ADAMS = Adams-Moulton, ERK = explicite Runge-Kutta and ARK = implicite Runge-Kutta.
All solvers are used in the NORMAL-Step method in a for-loop using the time-points defined in the text-file containing the states as output-points.
The bdf- and ARK-Solver use the SUNLinSol_Dense as linear solver. Notably here is that for the ARK-Solver the ode system is fully implicit solved (not only part of it).

Examples can be found in the vignette.
}
